
# Hidden Markov Model README

## Overview

This project implements a Hidden Markov Model (HMM) for sequence generation using a configurable number of states. The model parameters are specified in a YAML configuration file, and the implementation supports efficient sequence generation using various HMM techniques.

## Installation

To run this project, you need to have Python installed on your machine along with the following Python packages:
- `numpy`
- `pandas`

You can install these dependencies using `pip`:

```bash
pip install numpy pandas
```

## Usage

The primary script for this project is `HiddenMarkovModel.py`. To generate a sequence using the HMM, use the following command:

```bash
python HiddenMarkovModel.py generate 256 --config_file='markov/config/onehot_twenty_state_hmm.yaml'
```

### Command Explanation

- `python HiddenMarkovModel.py`: Invokes the Python interpreter to run the script.
- `generate 256`: Tells the script to generate a sequence of length 256.
- `--config_file='markov/config/onehot_twenty_state_hmm.yaml'`: Specifies the path to the YAML configuration file that contains the HMM parameters.

## Configuration

The configuration file (`onehot_twenty_state_hmm.yaml`) should be placed in the `markov/config` directory and must specify the parameters for the HMM, such as the number of states, emission probabilities, transition probabilities, and other relevant settings.

Here is an example of what the YAML configuration file might look like:

```yaml
num_states: 20
start_probabilities: 
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
  - 0.05
transition_matrix:
  - [0.1, 0.9, 0, 0, ...]
  - [0.2, 0.1, 0.7, 0, ...]
  - ...
emission_matrix:
  - [0.2, 0.8]
  - [0.5, 0.5]
  - ...
```

Ensure that the YAML file correctly matches the structure expected by the script.

## Example

After running the command to generate a sequence, the output will be a sequence of states or observations according to the specified HMM parameters. You can modify the configuration file to adjust the behavior and characteristics of the generated sequences.

## Contact

If you have any questions or need further assistance, please contact the project maintainer.

---

Feel free to customize this README file according to your project's specifics and requirements.
